library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity InputController is
  
  port (
    --Avalon
	clk        : in  std_logic;
    reset_n    : in  std_logic;
    read       : in  std_logic;
    write      : in  std_logic;
    chipselect : in  std_logic;
    address    : in  unsigned(9 downto 0);
    readdata   : out unsigned(15 downto 0);
    writedata  : in  unsigned(15 downto 0);
	inter	   : out std_logic; 
	--To switches
	SWITCH_1   : in std_logic;
	SWITCH_2	: in std_logic;
	SWITCH_3	: in std_logic;
	SWITCH_4	: in std_logic;
	SWITCH_5	: in std_logic
	);
end InputController;

architecture rtl of InputController is

type states is (IDLE, PRESSED,WAITST);
signal state, next_state : states;
signal we:std_Logic;
signal reset:std_logic;
signal counter: integer;

-- A bunch of signals for the button
-- The button clicks are first debounced and then
-- Pulsed
-- The naming follow this convention:
-- Initial    SWITCH_1   ______--_-_------------_--_________
-- Debounced  DSWITCH_1  ___________---------------_________
-- Pulsed     PSWITCH_1  ___________-_______________________

--Switch 1
signal DSWITCH_1:std_logic;
signal PSWITCH_1:std_logic;
--Switch 2
signal DSWITCH_2:std_logic;
signal PSWITCH_2:std_logic;
--Switch 3
signal DSWITCH_3:std_logic;
signal PSWITCH_3:std_logic;
--Switch 4
signal DSWITCH_4:std_logic;
signal PSWITCH_4:std_logic;
---Switch 5
signal DSWITCH_5:std_logic;
signal PSWITCH_5:std_logic;
--Debouncer 
component debouncer is port(
	clk		: in std_logic;
	key_in 	: in std_logic;
	key_out : out std_logic;
	reset : in std_logic
);
end component debouncer; 
--Pulser
component pulser is port(
	clk		: in std_logic;
	key_in 	: in std_logic;
	key_out : out std_logic;
	reset : in std_logic
);
end component pulser;  
begin
--Reset
reset <= not reset_n;
--Write enable
we <= '1' when chipselect ='1' and write='1' else '0';
--Debouncers
D1: debouncer port map(clk,SWITCH_1,DSWITCH_1,reset);
D2: debouncer port map(clk,SWITCH_2,DSWITCH_2,reset);	
D3: debouncer port map(clk,SWITCH_3,DSWITCH_3,reset);
D4: debouncer port map(clk,SWITCH_4,DSWITCH_4,reset);
D5: debouncer port map(clk,SWITCH_5,DSWITCH_5,reset);
--Pulsers
P1: pulser port map(clk,DSWITCH_1,PSWITCH_1,reset);
P2: pulser port map(clk,DSWITCH_2,PSWITCH_2,reset);	
P3: pulser port map(clk,DSWITCH_3,PSWITCH_3,reset);
P4: pulser port map(clk,DSWITCH_4,PSWITCH_4,reset);
P5: pulser port map(clk,DSWITCH_5,PSWITCH_5,reset);



--FSM Strandard next_state => state
process(clk)
begin
	if(rising_edge(clk)) then 
		if( reset_n='0' )
		then
			state <= IDLE;
		else
			state <= next_state;
			if (state = PRESSED) then 
				counter <=0;
			else counter <=counter +1;
		end if;
				
		end if;
	end if;
end process;


--Combinational process
process (state,SWITCH_1,we)
begin
	--By default reset the interuption signal
	inter <= '0';
	next_state <= state;
case state is

--Waiting for a button click 
when IDLE =>
inter <='0';
if (PSWITCH_1 = '0' or PSWITCH_2 = '0' or PSWITCH_3 = '0' or PSWITCH_4 = '0' or PSWITCH_5 = '0' ) 
then 
next_state <= PRESSED;
end if;


--A button has been pressed
--Stay into this state until the interuption has been cleared
when PRESSED =>
inter <='1';
if (we='1') 
then 
next_state <= WAITST;
end if;

when WAITST =>
inter <='0';
if (counter > 30000) 
then 
next_state <= IDLE;
end if;


end case;

end process;

 
end rtl;
